
%%Parametros iniciales%%

N1 = 1;  % El cuerpo central tiene (dos) una masas solares.
N2 = 3*(10^-6);
a=N1/N2;
pL1=[1-((a/3)^(1/3)) 0];
pL2=[1+((a/3)^(1/3)) 0];
pL3=[1-((5*a)/12) 0];
pL4=[(1/4)*((N1-N2)/(N1+N2)) sqrt(3)/4];
vL1=[0 29.78];
vL2=vL1;
vL3=[0 -29.78];
vL4=[(29.78/(sqrt(3+((N1-N2)/(N1+N2))^2))*(-sqrt(3))) (29.78/(sqrt(3+((N1-N2)/(N1+N2))^2))*((N1-N2)/(N1+N2)))];
r3=pL1;%Posicin satelite
v3=vL1;    %Veloc. inicial satelite
s3 = [r3 v3];
tspan = [0 1];   % Una rbita del planeta son aproximadamente 0.35 aos
xs=0;   % Posicin X de la estrella
ys=0;   % Posicin Y de la estrella
% Creo un vector de estructuras con los diferentes valores
% de los parmetros que controlan la precisin.
fun = @(t,s3) Problema3C-s(t,s3,N1);
OrbitaCompleta3= @(x3,y3) CoordenadaY3(x3,y3);

options3(3) = odeset('RelTol',1e-9,'AbsTol',1e-9,'Events',OrbitaCompleta3);

tabla453 = zeros(4,1);
tabla1133 = zeros(4,1);
%%Resolucion del problema para distintas tolerancias%%

 %%%Orbita para el satelite%%%
 
 % Solucin usando ODE45
    sol453=ode45(fun,tspan,s3,options3(3));
    t453=sol453.x;
    x453=sol453.y(1,:);
    y453=sol453.y(2,:);
    vx453=sol453.y(3,:);
    vy453=sol453.y(4,:);
% Integrales de movimiento usando la solucin de ODE45
    r3 = [x453 ; y453];
    v3 = [vx453 ; vy453];
    [E453 L453]=IntegralesProblema3C(r3,v3,N1);
% Solucin usando ODE113
    sol1133=ode113(fun,tspan,s3,options3(3));
    t1133=sol1133.x;
    x1133=sol1133.y(1,:);
    y1133=sol1133.y(2,:);
    vx1133=sol1133.y(3,:);
    vy1133=sol1133.y(4,:);
% Integrales de movimiento usando la solucin de ODE113
    r3 = [x1133 ; y1133];
    v3 = [vx1133 ; vy1133];
    [E1133 L1133]=IntegralesProblema3C(r3,v3,N1);
% Calculamos los valores que hemos de tabular.
    tabla453(1,1) = sol453.stats.nfevals;                 % No. de evaluaciones de las derivadas
    tabla453(2,1) = abs(max(E453)-min(E453))/abs(E453(1));  % Variacin relativa de la energa
    tabla453(3,1) = abs(max(L453)-min(L453))/abs(L453(1));  % Variacin relativa del momento angular
    tabla453(4,1) = sol453.x(length(sol453.x));            % Perodo orbital
    tabla1133(1,1) = sol1133.stats.nfevals;
    tabla1133(2,1) = abs(max(E1133)-min(E1133))/abs(E1133(1));
    tabla1133(3,1) = abs(max(L1133)-min(L1133))/abs(L1133(1));
    tabla1133(4,1) = sol1133.x(length(sol1133.x));
 
% Representamos las soluciones
    figure(1)
    hold on
    plot(xs,ys,'ok','MarkerFaceColor','k')
    plot(x453,y453,'g+-',x1133,y1133,'yv-')  %%Orbita satelite??? NO SALEEE!!!
    xlabel('x (U.A.)');
    ylabel('y (U.A.)');
    legend('Estrella','ode45(S)','ode113(S)','Location','SouthWest');
    titulo = ['rbita del planeta. RelTol , AbsTol = ' num2str(options(3).RelTol)];
    title(titulo);
    hold off
    figure(2);
    hold on
    plot(t453,E453,'g+-',t1133,E1133,'yv-');
    xlabel('t (aos)');
    ylabel('E/m (km^2/s^2)');
    legend('ode45(S)','ode113(S)','Location','SouthWest');
    titulo = ['Energa del planeta. RelTol , AbsTol = ' num2str(options(3).RelTol)];
    title(titulo);
    hold off
    figure(3);
    hold on
    plot(t453,L453,'g+-',t1133,L1133,'yv-')
    xlabel('t (aos)');
    ylabel('L/m (U.A. km/s)');
    legend('ode45','ode113','Location','SouthWest');
    titulo = ['Momento angular del planeta. RelTol , AbsTol = ' num2str(options(3).RelTol)];
    title(titulo);
    hold off
    

%%Tabla%%

fprintf('RelTol,AbsTol: \t \t 1e-9 \n');
fprintf('Funcin ode45(P): \n')
fprintf('No. de evaluaciones: \t %d \n',tabla45(1,1));
fprintf('|E_max-E_min|/|E_ini|: \t %6.3e \n',tabla45(2,1));
fprintf('|L_max-L_min|/L_ini: \t %6.3e \n',tabla45(3,1));
fprintf('Perodo orbital: \t %f \t (aos) \n',tabla45(4,1));
fprintf('Funcin ode113(P): \n');
fprintf('No. de evaluaciones: \t %d \n',tabla113(1,1));
fprintf('|E_max-E_min|/|E_ini|: \t %6.3e \n',tabla113(2,1));
fprintf('|L_max-L_min|/L_ini: \t %6.3e \n',tabla113(3,1));
fprintf('Perodo orbital: \t %f \t (aos) \n',tabla113(4,1));
fprintf('Funcin ode45(S): \n')
fprintf('No. de evaluaciones: \t %d \n',tabla453(1,1));
fprintf('|E_max-E_min|/|E_ini|: \t %6.3e \n',tabla453(2,1));
fprintf('|L_max-L_min|/L_ini: \t %6.3e \n',tabla453(3,1));
fprintf('Perodo orbital: \t %f \t (aos) \n',tabla453(4,1));
fprintf('Funcin ode113(S): \n');
fprintf('No. de evaluaciones: \t %d \n',tabla1133(1,1));
fprintf('|E_max-E_min|/|E_ini|: \t %6.3e \n',tabla1133(2,1));
fprintf('|L_max-L_min|/L_ini: \t %6.3e \n',tabla1133(3,1));
fprintf('Perodo orbital: \t %f \t (aos) \n',tabla1133(4,1));
